<?php require_once 'header.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>طرق الدفع</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { background: #181a20; color: #fff; }
        .payment-card {
            background: rgba(31, 41, 55, 0.95);
            border: 1px solid #374151;
            border-radius: 1.5rem;
            box-shadow: 0 4px 24px #0003;
            transition: 0.3s;
            padding: 2rem 1.5rem;
            margin-bottom: 2rem;
        }
        .payment-card:hover {
            box-shadow: 0 8px 32px #7367f055;
            transform: translateY(-8px) scale(1.03) rotate(1deg);
            border-color: #a78bfa;
        }
        .payment-icon {
            width: 64px; height: 64px;
            display: flex; align-items: center; justify-content: center;
            border-radius: 50%;
            margin: 0 auto 1rem auto;
            font-size: 2rem;
        }
        .gradient-red { background: linear-gradient(90deg, #ef4444 0%, #dc2626 100%); }
        .gradient-orange { background: linear-gradient(90deg, #f59e42 0%, #ea580c 100%); }
        .gradient-green { background: linear-gradient(90deg, #22c55e 0%, #16a34a 100%); }
        .gradient-blue { background: linear-gradient(90deg, #2563eb 0%, #0ea5e9 100%); }
        .gradient-purple { background: linear-gradient(90deg, #a78bfa 0%, #6366f1 100%); }
        .payment-number {
            background: #374151;
            color: #fff;
            border-radius: 0.5rem;
            padding: 0.5rem 1rem;
            font-family: monospace;
            margin: 0.5rem 0 1rem 0;
            display: inline-block;
        }
        .badge-green {
            background: #16a34a;
            color: #fff;
            font-size: 1rem;
            padding: 0.5rem 1.2rem;
            border-radius: 1rem;
            margin-bottom: 1.5rem;
            display: inline-block;
        }
        .section-title {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 1.5rem;
            color: #fff;
        }
        .section-desc {
            color: #bdbdbd;
            font-size: 1.2rem;
            margin-bottom: 2.5rem;
        }
        .feature-box {
            background: linear-gradient(90deg, #23272f 0%, #181a20 100%);
            border-radius: 1.5rem;
            padding: 2rem 1.5rem;
            margin-top: 3rem;
        }
        .feature-icon {
            font-size: 2rem;
            margin-left: 0.5rem;
        }
        .feature-title {
            color: #fff;
            font-size: 1.3rem;
            font-weight: bold;
        }
        .feature-desc {
            color: #bdbdbd;
            font-size: 1.1rem;
        }
    </style>
</head>
<body>
    <section class="py-5 px-2">
        <div class="container">
            <div class="text-center mb-4">
                <span class="badge-green">طرق الدفع</span>
                <div class="section-title">طرق دفع متنوعة وآمنة</div>
                <div class="section-desc">نوفر لك جميع طرق الدفع المحلية والعالمية لتسهيل عملية الشراء</div>
            </div>
            <div class="text-center mb-4">
                <div class="text-green fw-bold mb-2" style="font-size:1.2rem;">سعر الإيداع اليوم</div>
                <div class="text-green fw-bold" style="font-size:1.5rem;">(1$ دولار = 51.05 جنيه مصري)</div>
            </div>
            <div class="row justify-content-center">
                <!-- فودافون كاش -->
                <div class="col-md-6 col-lg-4">
                    <div class="payment-card text-center">
                        <div class="payment-icon gradient-red"><span>📱</span></div>
                        <div class="h4 mb-2">فودافون كاش</div>
                        <div class="payment-number">01067761719</div>
                        <div class="text-gray-300 mb-2">ادفع بسهولة من خلال محفظة فودافون كاش</div>
                    </div>
                </div>
                <!-- أورانج كاش -->
                <div class="col-md-6 col-lg-4">
                    <div class="payment-card text-center">
                        <div class="payment-icon gradient-orange"><span>🧡</span></div>
                        <div class="h4 mb-2">أورانج كاش</div>
                        <div class="payment-number">01067761719</div>
                        <div class="text-gray-300 mb-2">استخدم محفظة أورانج كاش للدفع الآمن</div>
                    </div>
                </div>
                <!-- اتصالات كاش -->
                <div class="col-md-6 col-lg-4">
                    <div class="payment-card text-center">
                        <div class="payment-icon gradient-green"><span>📞</span></div>
                        <div class="h4 mb-2">إتصالات كاش</div>
                        <div class="payment-number">01067761719</div>
                        <div class="text-gray-300 mb-2">ادفع بسهولة من خلال محفظة إتصالات كاش</div>
                    </div>
                </div>
                <!-- وي كاش -->
                <div class="col-md-6 col-lg-4">
                    <div class="payment-card text-center">
                        <div class="payment-icon gradient-blue"><span>🌐</span></div>
                        <div class="h4 mb-2">وي كاش</div>
                        <div class="payment-number">01067761719</div>
                        <div class="text-gray-300 mb-2">استخدم محفظة وي كاش للدفع السريع</div>
                    </div>
                </div>
                <!-- تحويل بنكي -->
                <div class="col-md-6 col-lg-4">
                    <div class="payment-card text-center">
                        <div class="payment-icon gradient-purple"><span>🏦</span></div>
                        <div class="h4 mb-2">تحويل بنكي</div>
                        <div class="payment-number">حساب بنكي / انستاباي</div>
                        <div class="text-gray-300 mb-2">تحويل مباشر من البنك أو عبر تطبيقات الدفع</div>
                    </div>
                </div>
            </div>
            <div class="feature-box text-center mt-5">
                <div class="row">
                    <div class="col-md-4 mb-3 mb-md-0">
                        <div class="feature-title"><span class="feature-icon">🔒</span>تشفير SSL</div>
                        <div class="feature-desc">حماية بياناتك أثناء الدفع</div>
                    </div>
                    <div class="col-md-4 mb-3 mb-md-0">
                        <div class="feature-title"><span class="feature-icon">✅</span>ضمان الاسترداد</div>
                        <div class="feature-desc">استرجاع أموالك في حال وجود مشكلة</div>
                    </div>
                    <div class="col-md-4">
                        <div class="feature-title"><span class="feature-icon">⚡</span>تأكيد فوري</div>
                        <div class="feature-desc">تفعيل الخدمة فور الدفع</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</body>
</html>